#define _QCAP_LABVIEW_IMPORT
typedef int                 BOOL;
#define FALSE 0
#define TRUE 1
typedef int INT;
#include <QDebug>
#include <qfiledialog.h>
#include <QMessageBox>

#include "fileplayerdlg.h"
#include "ui_fileplayerdlg.h"

#include "QCAP.H"

QRETURN on_video_decoder_file_callback( PVOID pFile, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData )
{
    //FilePlayerDlg * pFilePlayerDlg = (FilePlayerDlg *)(pUserData);

//	qDebug( "on_video_decoder_file_callback( %f, %d )", dSampleTime, nFrameBufferLen );

    return QCAP_RT_OK;
}

QRETURN on_audio_decoder_file_callback( PVOID pFile, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData )
{
    FilePlayerDlg * pFilePlayerDlg = (FilePlayerDlg *)(pUserData);

//	qDebug( "on_audio_decoder_file_callback( %f, %d )", dSampleTime, nFrameBufferLen );

    if( pFilePlayerDlg->m_nAudioBitsPerSample == 16 &&

            pFilePlayerDlg->m_nAudioChannels == 2 ) {

            double  L = 0;

            double  R = 0;

            SHORT * po = (SHORT *)(pFrameBuffer);

            ULONG   samples = nFrameBufferLen / 4; // 16BITS L + R

            for( ULONG i = 0 ; i < samples ; i++ ) {

                L += abs(*po++);

                R += abs(*po++);
            }
            L /= samples;

            R /= samples;

            double DB_L = 20 * log10( L / 32768.0 );

            double DB_R = 20 * log10( R / 32768.0 );

            pFilePlayerDlg->g_d_audio_volume_db_left = DB_L;

            pFilePlayerDlg->g_d_audio_volume_db_right = DB_R;
        }

    return QCAP_RT_OK;
}

QRETURN on_snapshot_done_callback( PVOID pFile, CHAR * pszFilePathName, PVOID pUserData )
{
    qDebug( "on_snapshot_done_callback( %s )", pszFilePathName );

    return QCAP_RT_OK;
}

FilePlayerDlg::FilePlayerDlg(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::FilePlayerDlg)
{
    ui->setupUi(this);

    this->setWindowTitle("File Player");

    this->setMinimumSize(660,620);

    this->setMaximumSize(660,620);

    ui->pushButton_PLAY->setEnabled(false);

    ui->pushButton_PAUSE->setEnabled(false);

    ui->pushButton_SPEED_PLUS->setEnabled(false);

    ui->pushButton_SPEED_MINUS->setEnabled(false);

    ui->pushButton_STOP->setEnabled(false);

    ui->pushButton_SANPSHOT->setEnabled(false);

    ui->pushButton_ANALYSIS->setEnabled(false);

    ui->label_FileInfo->setWordWrap(true);

    ui->label_FileInfo->setAlignment(Qt::AlignTop);

    ui->progressBar_Audio_Volume_L->setValue(0);

    ui->progressBar_Audio_Volume_R->setValue(0);

    ui->progressBar_File_Position->setValue(0);

    CoInitialize( NULL );

    //INITIALIZE MEMBER VARIABLES

    m_pFile = NULL;

    m_nVideoFormat = 0;

    m_nVideoWidth = 0;

    m_nVideoHeight = 0;

    m_dVideoFrameRate = 0.0;

    m_nAudioFormat = 0;

    m_nAudioChannels = 0;

    m_nAudioBitsPerSample = 0;

    m_nAudioSampleFrequency = 0;

    m_dFileTotalDuationTimes = 0;

    m_nFileTotalVideoFrames = 0;

    m_nFileTotalAudioFrames = 0;

	m_nFileTotalMetadataFrames = 0;

    g_d_audio_volume_db_left = 0;

    g_d_audio_volume_db_right = 0;
}

FilePlayerDlg::~FilePlayerDlg()
{
    if( m_pFile ) {

        QCAP_DESTROY_FILE( m_pFile );

        m_pFile = NULL;
    }

    killTimer( m_nTimerId_1 );

    killTimer( m_nTimerId_2 );

    CoUninitialize();

    delete ui;
}

void FilePlayerDlg::on_pushButton_OPEN_clicked()
{
    FilePath = QFileDialog::getOpenFileName(this,"open file",".", "Video Files (*.ASF;*.FLV;*.MP4;*.TS;*.WMV)");

    FilePath_ByteArray = FilePath.toLocal8Bit();

    psz = FilePath_ByteArray.data();

    if( strlen(psz) > 0 )
    {
        if( m_pFile ) {

            QCAP_DESTROY_FILE( m_pFile );

            m_pFile = NULL;
        }

        QCAP_OPEN_FILE( psz, &m_pFile, QCAP_DECODER_TYPE_SOFTWARE, &m_nVideoFormat, &m_nVideoWidth, &m_nVideoHeight, &m_dVideoFrameRate, &m_nAudioFormat, &m_nAudioChannels, &m_nAudioBitsPerSample, &m_nAudioSampleFrequency, &m_dFileTotalDuationTimes, &m_nFileTotalVideoFrames, &m_nFileTotalAudioFrames, &m_nFileTotalMetadataFrames, (HWND)ui->DisplayWindow->winId(), 1 );

        QCAP_REGISTER_VIDEO_DECODER_FILE_CALLBACK( m_pFile, on_video_decoder_file_callback, this );

        QCAP_REGISTER_AUDIO_DECODER_FILE_CALLBACK( m_pFile, on_audio_decoder_file_callback, this );

        QCAP_REGISTER_FILE_SNAPSHOT_DONE_CALLBACK( m_pFile, on_snapshot_done_callback, this );

        QCAP_PAUSE_FILE( m_pFile );

        //
        speed = 0;

        QCAP_GET_FILE_PLAYBACK_SPEED( m_pFile, &speed );

        if( m_nVideoFormat == QCAP_ENCODER_FORMAT_H264 ) { vfmt = "H264"; }

        if( m_nAudioFormat == QCAP_ENCODER_FORMAT_PCM ) { afmt = "PCM"; }

        if( m_nAudioFormat == QCAP_ENCODER_FORMAT_AAC_RAW ) { afmt = "AAC RAW"; }

        if( m_nAudioFormat == QCAP_ENCODER_FORMAT_AAC_ADTS ) { afmt = "AAC ADTS"; }

        psz_info.sprintf("File Path = %s\r\nFile Total Duration Times = %f sec\r\nFile Total Video Frames = %d\r\nFile Total Audio Frames = %d\r\nVideo Encoder Format = %s\r\nVideo Width = %d\r\nVideo Height = %d\r\nVideo Frame Rate = %f fps\r\nAudio Encoder Format = %s\r\nAudio Channels = %d\r\nAudio Bits Per Sample = %d bits\r\nAudio Sample Frequency = %d Hz\r\nPlayback Speed = %f"

                         , psz, m_dFileTotalDuationTimes, m_nFileTotalVideoFrames, m_nFileTotalAudioFrames, vfmt, m_nVideoWidth, m_nVideoHeight, m_dVideoFrameRate, afmt, m_nAudioChannels, m_nAudioBitsPerSample, m_nAudioSampleFrequency, speed);

        ui->label_FileInfo->setText(psz_info);

        //
        ui->pushButton_PLAY->setEnabled(true);

        ui->pushButton_PAUSE->setEnabled(true);

        ui->pushButton_SPEED_PLUS->setEnabled(true);

        ui->pushButton_SPEED_MINUS->setEnabled(true);

        ui->pushButton_STOP->setEnabled(true);

        ui->pushButton_SANPSHOT->setEnabled(true);

        ui->pushButton_ANALYSIS->setEnabled(true);

        m_nTimerId_1 = startTimer(10);

        m_nTimerId_2 = startTimer(100);
    }
    else
    {
        return;
    }
}

void FilePlayerDlg::on_pushButton_PLAY_clicked()
{
    if( m_pFile != NULL)
    {
        double dSampleTime = 0;

        QCAP_GET_FILE_POSITION( m_pFile, &dSampleTime );

        if( dSampleTime >= m_dFileTotalDuationTimes ) {

            QCAP_STOP_FILE( m_pFile );
        }

        QCAP_PLAY_FILE( m_pFile );
    }
}

void FilePlayerDlg::on_pushButton_PAUSE_clicked()
{
    if( m_pFile != NULL)
    {
        QCAP_PAUSE_FILE( m_pFile );
    }
}

void FilePlayerDlg::on_pushButton_STOP_clicked()
{
    if( m_pFile != NULL)
    {
        QCAP_STOP_FILE( m_pFile );
    }
}

void FilePlayerDlg::on_pushButton_SPEED_PLUS_clicked()
{
    if( m_pFile != NULL )
    {
        QCAP_GET_FILE_PLAYBACK_SPEED( m_pFile, &speed );

        speed += 0.25;

        QCAP_SET_FILE_PLAYBACK_SPEED( m_pFile,  speed );

        QCAP_GET_FILE_PLAYBACK_SPEED( m_pFile, &speed );

        psz_info.sprintf("File Path = %s\r\nFile Total Duration Times = %f sec\r\nFile Total Video Frames = %d\r\nFile Total Audio Frames = %d\r\nVideo Encoder Format = %s\r\nVideo Width = %d\r\nVideo Height = %d\r\nVideo Frame Rate = %f fps\r\nAudio Encoder Format = %s\r\nAudio Channels = %d\r\nAudio Bits Per Sample = %d bits\r\nAudio Sample Frequency = %d Hz\r\nPlayback Speed = %f"

                         , psz, m_dFileTotalDuationTimes, m_nFileTotalVideoFrames, m_nFileTotalAudioFrames, vfmt, m_nVideoWidth, m_nVideoHeight, m_dVideoFrameRate, afmt, m_nAudioChannels, m_nAudioBitsPerSample, m_nAudioSampleFrequency, speed);

        ui->label_FileInfo->setText(psz_info);
    }
}

void FilePlayerDlg::on_pushButton_SPEED_MINUS_clicked()
{
    if( m_pFile != NULL )
    {
        QCAP_GET_FILE_PLAYBACK_SPEED( m_pFile, &speed );

        speed -= 0.25;

        QCAP_SET_FILE_PLAYBACK_SPEED( m_pFile,  speed );

        QCAP_GET_FILE_PLAYBACK_SPEED( m_pFile, &speed );

        psz_info.sprintf("File Path = %s\r\nFile Total Duration Times = %f sec\r\nFile Total Video Frames = %d\r\nFile Total Audio Frames = %d\r\nVideo Encoder Format = %s\r\nVideo Width = %d\r\nVideo Height = %d\r\nVideo Frame Rate = %f fps\r\nAudio Encoder Format = %s\r\nAudio Channels = %d\r\nAudio Bits Per Sample = %d bits\r\nAudio Sample Frequency = %d Hz\r\nPlayback Speed = %f"

                         , psz, m_dFileTotalDuationTimes, m_nFileTotalVideoFrames, m_nFileTotalAudioFrames, vfmt, m_nVideoWidth, m_nVideoHeight, m_dVideoFrameRate, afmt, m_nAudioChannels, m_nAudioBitsPerSample, m_nAudioSampleFrequency, speed);

        ui->label_FileInfo->setText(psz_info);
    }
}

void FilePlayerDlg::on_pushButton_SANPSHOT_clicked()
{
    if( m_pFile != NULL )
    {
        QCAP_SNAPSHOT_FILE_BMP( m_pFile, "FilePlayer.BMP"  );
    }
}

void FilePlayerDlg::on_pushButton_ANALYSIS_clicked()
{
    QString fn = QFileDialog::getSaveFileName (this, tr("Save LOG File"), "ANALYSIS",tr("Text Files(*.log)"));

    if(!fn.isEmpty())
    {
        QFile file(fn);

        if(!fn.endsWith(".log", Qt::CaseInsensitive))
        {
            fn = fn+".log";
        }
        else
        {
            fn = fn;
        }

        file.open (QFile::WriteOnly);

        QTextStream out(&file);

        psz_info.sprintf("File Path = %s\r\nFile Total Duration Times = %f sec\r\nFile Total Video Frames = %d\r\nFile Total Audio Frames = %d\r\nVideo Encoder Format = %s\r\nVideo Width = %d\r\nVideo Height = %d\r\nVideo Frame Rate = %f fps\r\nAudio Encoder Format = %s\r\nAudio Channels = %d\r\nAudio Bits Per Sample = %d bits\r\nAudio Sample Frequency = %d Hz\r\n"

                         , psz, m_dFileTotalDuationTimes, m_nFileTotalVideoFrames, m_nFileTotalAudioFrames, vfmt, m_nVideoWidth, m_nVideoHeight, m_dVideoFrameRate, afmt, m_nAudioChannels, m_nAudioBitsPerSample, m_nAudioSampleFrequency);

        out << psz_info;

        ULONG  nStreamBufferSize = m_nVideoWidth * m_nVideoHeight * 3 / 2;

        BYTE * pStreamBuffer = (BYTE *)(malloc( nStreamBufferSize ));

        double dLastSampleTime = 0;

        out << "\r\n[VIDEO STREAM]\r\n\r\n";

        for( ULONG i = 0 ; i < m_nFileTotalVideoFrames ; i++ ) {

            ULONG  nStreamBufferLen = nStreamBufferSize;

            BOOL   bIsKeyFrame = FALSE;

            double dSampleTime = 0;

            QCAP_GET_VIDEO_FILE_STREAM_BUFFER( m_pFile, i, pStreamBuffer, &nStreamBufferLen, &bIsKeyFrame, &dSampleTime );

            psz_info.sprintf("%08d %f (%f) - %d BYTES\t[%02X%02X%02X%02X%02X%02X%02X%02X %02X%02X%02X%02X%02X%02X%02X%02X] %s\r\n"

                             , i, dSampleTime, dSampleTime - dLastSampleTime, nStreamBufferLen, pStreamBuffer[ 0 ], pStreamBuffer[ 1 ], pStreamBuffer[ 2 ], pStreamBuffer[ 3 ], pStreamBuffer[ 4 ], pStreamBuffer[ 5 ], pStreamBuffer[ 6 ], pStreamBuffer[ 7 ], pStreamBuffer[ 8 ], pStreamBuffer[ 9 ], pStreamBuffer[ 10 ], pStreamBuffer[ 11 ], pStreamBuffer[ 12 ], pStreamBuffer[ 13 ], pStreamBuffer[ 14 ], pStreamBuffer[ 15 ], bIsKeyFrame ? "[I]" : "" );

            out << psz_info;

            dLastSampleTime = dSampleTime;
        }

        out << "\r\n[AUDIO STREAM]\r\n\r\n";

        dLastSampleTime = 0;

        for(ULONG i = 0 ; i < m_nFileTotalAudioFrames ; i++ ) {

            ULONG  nStreamBufferLen = nStreamBufferSize;

            double dSampleTime = 0;

            QCAP_GET_AUDIO_FILE_STREAM_BUFFER( m_pFile, i, pStreamBuffer, &nStreamBufferLen, &dSampleTime );

            psz_info.sprintf("%08d %f (%f) - %d BYTES\t[%02X%02X%02X%02X%02X%02X%02X%02X %02X%02X%02X%02X%02X%02X%02X%02X]\r\n"

                             , i, dSampleTime, dSampleTime - dLastSampleTime, nStreamBufferLen, pStreamBuffer[ 0 ], pStreamBuffer[ 1 ], pStreamBuffer[ 2 ], pStreamBuffer[ 3 ], pStreamBuffer[ 4 ], pStreamBuffer[ 5 ], pStreamBuffer[ 6 ], pStreamBuffer[ 7 ], pStreamBuffer[ 8 ], pStreamBuffer[ 9 ], pStreamBuffer[ 10 ], pStreamBuffer[ 11 ], pStreamBuffer[ 12 ], pStreamBuffer[ 13 ], pStreamBuffer[ 14 ], pStreamBuffer[ 15 ]);

            out << psz_info;

            dLastSampleTime = dSampleTime;
        }

        file.close();

        if( pStreamBuffer ) {

            free( pStreamBuffer );

            pStreamBuffer = NULL;
        }
    }

    QMessageBox::information(NULL, "ANALYSIS", "PLEASE CHECK ANALYSIS.LOG");
}

void FilePlayerDlg::timerEvent( QTimerEvent *event )
{
    if( event->timerId() == m_nTimerId_1 )
    {
        if( m_pFile )
        {
            double dSampleTime = 0;

            QCAP_GET_FILE_POSITION( m_pFile, &dSampleTime );

            ui->progressBar_File_Position->setValue( (int)(100.0 * (dSampleTime / m_dFileTotalDuationTimes)) );
        }
    }
    if( event->timerId() == m_nTimerId_2 )
    {
        ui->progressBar_Audio_Volume_L->setValue((int)(100.0 + g_d_audio_volume_db_left));

        ui->progressBar_Audio_Volume_R->setValue((int)(100.0 + g_d_audio_volume_db_right));
    }
}
